<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * expensePlane
 *
 * @author		expensePlane Developers & Contributors
 * @copyright	Copyright (c) 2012 - 2018 expensePlane.com
 * @license		https://expenseplane.com/license.txt
 * @link		https://expenseplane.com
 */

/**
 * Class expense
 */
class Expenses extends Admin_Controller
{
    /**
     * expense constructor.
     */
    public function __construct()
    {
        $this->load->library('session');

        $userTypeId = $this->session->userdata('user_type');
        parent::__construct($userTypeId);

        $this->load->model('mdl_expenses');
    }

    /**
     * @param int $page
     */
    public function index($page = 0)
    {
        $this->mdl_expenses->paginate(site_url('expenses/index'), $page);
        $expenses = $this->mdl_expenses->expenseItems();



        $this->layout->set('expenses', $expenses);
        $this->layout->buffer('content', 'expenses/index');
        $this->layout->render();
    }

    /**
     * @param null $id
     */
    public function edit($id = null)
    {
        if ($this->input->post('btn_cancel')) {
            redirect('expenses');
        }

        if ($this->input->post('btn_save')) {
            redirect('expenses/ajax/update/',$id);
        }

        if ($id and !$this->input->post('btn_submit')) {
            if (!$this->mdl_expenses->prep_form($id)) {
                show_404();
            }
        }

        $this->load->model('mdl_expenses');
        $this->load->model('mdl_expense_items');


        $this->layout->set(
            array(
                'expenses' => $this->mdl_expenses->get_expenses($id),
                'items' => $this->mdl_expense_items->get_items($id)

            )
        );



        $this->layout->buffer(
            [
            ['content', 'expenses/edit'],
            ['modal_delete_expense', 'expenses/modal_delete_expense']
            ]
    );

        $this->layout->render();
    }

    public function form($id = null)
    {
        if ($this->input->post('btn_cancel')) {
            redirect('expenses');
        }

        if ($this->mdl_expenses->run_validation()) {
            // Get the db array
            $db_array = $this->mdl_expenses->db_array();
            $restData = $this->mdl_expenses->save($id, $db_array);
            redirect('expenses/form', $restData);
        }

        if ($id and !$this->input->post('btn_submit')) {
            if (!$this->mdl_expenses->prep_form($id)) {
                show_404();
            }
        }

        $this->load->model('families/mdl_families');
        $this->load->model('payment_methods/mdl_payment_methods');


        $this->layout->set(
            array(
                'families' => $this->mdl_families->get()->result(),
                'payment_methods' => $this->mdl_payment_methods->get()->result()

            )
        );

        $this->layout->buffer('content', 'expenses/form');
        $this->layout->render();
    }

    public function generate_pdf($expense_id, $stream = true, $expense_template = null)
    {
        $this->load->helper('pdf');



        generate_expense_pdf($expense_id, $stream, $expense_template);
    }


    public function delete($expense_id)
    {
        // Get the status of the invoice
        $expenses = $this->mdl_expenses->delete($expense_id);
        $items = $this->mdl_expenses->delete_items($expense_id);

            // If invoice refers to tasks, mark those tasks back to 'Complete'
        if($expenses && $items){
            // Delete the expense

            return true;


        } else {
            // Add alert that invoices can't be deleted
            //$this->session->set_flashdata('alert_error', trans('invoice_deletion_forbidden'));
        }

        // Redirect to invoice index
        redirect('expenses/index');
    }



}
